package com.ejie.ab18a.control;


import com.ejie.ab18a.service.Ab18aEventosService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.ab18a.model.Ab18aEventos;

/**
 * Ab18a12s00Controller generated by XXXX, 03-feb-2017 12:02:33.
 * @author XXXX
 */
 
@Controller
@RequestMapping (value = "/ab18a12s00")

public class Ab18a12s00Controller  {

	private static final Logger logger = LoggerFactory.getLogger(Ab18a12s00Controller.class);

	@Autowired
	private Ab18aEventosService ab18a12s00Service;
	
	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */
	
	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador indicado.
	 * 
	 * @param t12IdEvento Long
	 * @return Ab18a12s00 
	 *            Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{t12IdEvento}", method = RequestMethod.GET)
	public @ResponseBody Ab18aEventos get(@PathVariable Long t12IdEvento) {
        Ab18aEventos ab18a12s00 = new Ab18aEventos();
		ab18a12s00.setT12IdEvento(t12IdEvento);
        ab18a12s00 = this.ab18a12s00Service.find(ab18a12s00);
        Ab18a12s00Controller.logger.info("[GET - findBy_PK] : Obtener Ab18a12s00 por PK");
        return ab18a12s00;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterAb18a12s00 Ab18a12s00
	 *            Objeto que contiene los parametros de filtrado utilizados en
	 *            la busqueda.
	 * @return List<Ab18a12s00> 
	 *            Lista de objetos correspondientes a la busqueda realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Ab18aEventos> getAll(@ModelAttribute Ab18aEventos filterAb18a12s00) {
		Ab18a12s00Controller.logger.info("[GET - find_ALL] : Obtener Ab18a12s00 por filtro");
	    return this.ab18a12s00Service.findAll(filterAb18a12s00, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param ab18a12s00 Ab18a12s00 
	 *            Bean que contiene la informacion a modificar.
	 * @return Ab18a12s00 
	 *            Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Ab18aEventos edit(@RequestBody Ab18aEventos ab18a12s00) {		
        Ab18aEventos ab18a12s00Aux = this.ab18a12s00Service.update(ab18a12s00);
		Ab18a12s00Controller.logger.info("[PUT] : Ab18a12s00 actualizado correctamente");
        return ab18a12s00Aux;
    }

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 *
	 * @param ab18a12s00 Ab18a12s00 
	 *            Bean que contiene la informacion con la que se va a crear el
	 *            nuevo registro.
	 * @return Ab18a12s00
	 *            Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Ab18aEventos add(@RequestBody Ab18aEventos ab18a12s00) {		
        Ab18aEventos ab18a12s00Aux = this.ab18a12s00Service.add(ab18a12s00);
        Ab18a12s00Controller.logger.info("[POST] : Ab18a12s00 insertado correctamente");
    	return ab18a12s00Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 *
	 * @param t12IdEvento Long
	 *            Identificador del objeto que se desea eliminar.
	 * @return Ab18a12s00
	 *            Bean eliminado.
	 */
	@RequestMapping(value = "/{t12IdEvento}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Ab18aEventos remove(@PathVariable Long t12IdEvento) {
        Ab18aEventos ab18a12s00 = new Ab18aEventos();
        ab18a12s00.setT12IdEvento(t12IdEvento);
        this.ab18a12s00Service.remove(ab18a12s00);
       	Ab18a12s00Controller.logger.info("[DELETE] : Ab18a12s00 borrado correctamente");
       	return ab18a12s00;
    }
    
	
	/*
	 * METODOS COMPONENTE RUP_TABLE
	 * 
	 */

	 /**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Ab18a12s00Controller.logger.info("[GET - View] : ab18a12s00");
		return "ab18a12s00";
	}
	 
	 /**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAb18a12s00 Ab18a12s00
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Ab18a12s00>
	 *            Dto que contiene el resultado del filtrado realizado por el 
	 *            componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<Ab18aEventos> filter(
			@RequestJsonBody(param="filter") Ab18aEventos filterAb18a12s00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Ab18a12s00Controller.logger.info("[POST - filter] : Obtener Ab18a12s00s");
		return this.ab18a12s00Service.filter(filterAb18a12s00, jqGridRequestDto, false);
	}
	 
	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAb18a12s00 Ab18a12s00
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param searchAb18a12s00 Ab18a12s00
	 *            Bean que contiene los parametros de busqueda a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Ab18a12s00> 
	 *            Dto que contiene el resultado de la busqueda realizada por el
	 *            componente RUP_TABLE. 
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody List<TableRowDto<Ab18aEventos>> search(
			@RequestJsonBody(param="filter") Ab18aEventos filterAb18a12s00,
			@RequestJsonBody(param="search") Ab18aEventos searchAb18a12s00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Ab18a12s00Controller.logger.info("[POST - search] : Buscar Ab18a12s00s");
		return this.ab18a12s00Service.search(filterAb18a12s00, searchAb18a12s00, jqGridRequestDto, false);
	}
	
	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAb18a12s00 Ab18a12s00
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String>
	 *            Lista de los identificadores de los registros eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<String> removeMultiple(
			@RequestJsonBody(param="filter") Ab18aEventos filterAb18a12s00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Ab18a12s00Controller.logger.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Ab18a12s00s");
		this.ab18a12s00Service.removeMultiple(filterAb18a12s00, jqGridRequestDto, false);
		Ab18a12s00Controller.logger.info("All entities correctly deleted!");
		
		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}
	
	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */
	
	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAb18a12s00 Ab18a12s00
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Ab18a12s00>>
	 *            Dto que contiene el resultado del filtrado realizado por el
	 *            componente RUP_TABLE. 
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<JerarquiaDto<Ab18aEventos>> jerarquia(
			@RequestJsonBody(param="filter") Ab18aEventos filterAb18a12s00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Ab18a12s00Controller.logger.info("[POST - jerarquia] : Obtener Ab18a12s00s jerarquia");
		return this.ab18a12s00Service.jerarquia(filterAb18a12s00, jqGridRequestDto, false);
	}
	
	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion jerarquica.
	 * 
	 * @param filterAb18a12s00 Ab18a12s00
	 *            Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Ab18a12s00>>
	 *            Dto que contiene el resultado del filtrado realizado por el
	 *            componente RUP_TABLE. 
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<JerarquiaDto<Ab18aEventos>> jerarquiaChildren(
			@RequestJsonBody(param="filter") Ab18aEventos  filterAb18a12s00 ,
			@RequestJsonBody JQGridRequestDto  jqGridRequestDto) {
		Ab18a12s00Controller.logger.info("[POST - jerarquia] : Obtener Ab18a12s00s jerarquia - Hijos");
		return this.ab18a12s00Service.jerarquiaChildren(filterAb18a12s00, jqGridRequestDto);
	}
	
}	
